/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.util.ITextHolder;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateServerTextHolderPacket {
    private final BlockPos pos;
    public final ITextComponent[] signText;
    public final int lines;

    public UpdateServerTextHolderPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.lines = buf.readInt();
        this.signText = new ITextComponent[this.lines];
        for (int i = 0; i < this.lines; ++i) {
            this.signText[i] = buf.func_179258_d();
        }
    }

    public UpdateServerTextHolderPacket(BlockPos pos, ITextComponent[] signText, int lines) {
        this.pos = pos;
        this.lines = lines;
        this.signText = signText;
    }

    public static void buffer(UpdateServerTextHolderPacket message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeInt(message.lines);
        for (int i = 0; i < message.lines; ++i) {
            buf.func_179256_a(message.signText[i]);
        }
    }

    public static void handler(UpdateServerTextHolderPacket message, Supplier<NetworkEvent.Context> ctx) {
        World world = Objects.requireNonNull(ctx.get().getSender()).field_70170_p;
        ctx.get().enqueueWork(() -> {
            BlockPos pos;
            TileEntity tileentity;
            if (world != null && (tileentity = world.func_175625_s(pos = message.pos)) instanceof ITextHolder) {
                ITextHolder te = (ITextHolder)tileentity;
                if (te.getTextHolder().size == message.lines) {
                    for (int i = 0; i < message.lines; ++i) {
                        te.getTextHolder().setText(i, message.signText[i]);
                    }
                }
                BlockState state = world.func_180495_p(pos);
                world.func_184138_a(pos, state, state, 3);
                tileentity.func_70296_d();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

