/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.entities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FireworkRocketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.BasicTrade;
import net.minecraftforge.event.village.WandererTradesEvent;

public class VillagerTradesHandler {
    private static final float BUY = 0.05f;
    private static final float SELL = 0.2f;
    public static final VillagerTrades.ITrade[] TRADES;

    static BasicTrade itemForEmeraldTrade(IItemProvider item2, int quantity, int price, int maxTrades) {
        return VillagerTradesHandler.itemForEmeraldTrade(new ItemStack(item2, quantity), price, maxTrades);
    }

    static BasicTrade itemForEmeraldTrade(ItemStack itemStack, int price, int maxTrades) {
        return new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, price), itemStack, maxTrades, 1, 0.05f);
    }

    static BasicTrade itemForEmeraldTrade(IItemProvider item2, int quantity, IItemProvider additional, int addQuantity, int price, int maxTrades) {
        return new BasicTrade(new ItemStack((IItemProvider)Items.field_151166_bC, price), new ItemStack(additional, addQuantity), new ItemStack(item2, quantity), maxTrades, 1, 0.05f);
    }

    public static CompoundNBT createRandomFireworkStar(Random random) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74774_a("Type", (byte)FireworkRocketItem.Shape.values()[random.nextInt(FireworkRocketItem.Shape.values().length)].func_196071_a());
        tag.func_74757_a("Flicker", random.nextFloat() < 0.42f);
        tag.func_74757_a("Trail", random.nextFloat() < 0.42f);
        ArrayList list = Lists.newArrayList();
        int colors = 0;
        do {
            list.add(DyeColor.values()[random.nextInt(DyeColor.values().length)].func_196060_f());
        } while (random.nextFloat() < 0.42f && ++colors < 9);
        tag.func_197646_b("Colors", (List)list);
        if (random.nextBoolean()) {
            ArrayList fadeList = Lists.newArrayList();
            colors = 0;
            do {
                fadeList.add(DyeColor.values()[random.nextInt(DyeColor.values().length)].func_196060_f());
            } while (random.nextFloat() < 0.42f && ++colors < 9);
            tag.func_197646_b("FadeColors", (List)fadeList);
        }
        return tag;
    }

    public static void registerWanderingTraderTrades(WandererTradesEvent event) {
        int i;
        if (((Boolean)RegistryConfigs.reg.GLOBE_ENABLED.get()).booleanValue()) {
            for (i = 0; i < ServerConfigs.cached.GLOBE_TRADES; ++i) {
                event.getRareTrades().add(VillagerTradesHandler.itemForEmeraldTrade((IItemProvider)ModRegistry.GLOBE_ITEM.get(), 1, 10, 3));
            }
        }
        if (((Boolean)RegistryConfigs.reg.FLAX_ENABLED.get()).booleanValue()) {
            for (i = 0; i < 2; ++i) {
                event.getGenericTrades().add(VillagerTradesHandler.itemForEmeraldTrade((IItemProvider)ModRegistry.FLAX_SEEDS_ITEM.get(), 1, 6, 8));
            }
        }
    }

    static {
        ArrayList<Object> trades = new ArrayList<Object>();
        if (((Boolean)RegistryConfigs.reg.ROPE_ENABLED.get()).booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((IItemProvider)ModRegistry.ROPE_ITEM.get(), 4, 1, 10));
        }
        trades.add(VillagerTradesHandler.itemForEmeraldTrade((IItemProvider)Items.field_151016_H, 2, 1, 8));
        if (((Boolean)RegistryConfigs.reg.COPPER_LANTERN_ENABLED.get()).booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((IItemProvider)ModRegistry.COPPER_LANTERN.get(), 1, 1, 12));
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((IItemProvider)ModRegistry.BOMB_ITEM.get(), 1, 3, 8));
        }
        trades.add(new StarForEmeraldTrade(2, 8));
        trades.add(new RocketForEmeraldTrade(3, 1, 3, 8));
        trades.add(VillagerTradesHandler.itemForEmeraldTrade((IItemProvider)Items.field_221649_bM, 1, 4, 8));
        if (((Boolean)RegistryConfigs.reg.ROPE_ARROW_ENABLED.get()).booleanValue()) {
            Item i = (Item)ModRegistry.ROPE_ARROW_ITEM.get();
            ItemStack stack = new ItemStack((IItemProvider)i);
            stack.func_196085_b(Math.max(0, stack.func_77958_k() - 16));
            trades.add(VillagerTradesHandler.itemForEmeraldTrade(stack, 4, 6));
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            trades.add(VillagerTradesHandler.itemForEmeraldTrade((IItemProvider)ModRegistry.BOMB_BLUE_ITEM.get(), 1, (IItemProvider)ModRegistry.BOMB_ITEM.get(), 1, 40, 3));
        }
        TRADES = trades.toArray(new VillagerTrades.ITrade[0]);
    }

    static class StarForEmeraldTrade
    implements VillagerTrades.ITrade {
        private final int maxTrades;
        private final int price;

        public StarForEmeraldTrade(int price, int maxTrades) {
            this.price = price;
            this.maxTrades = maxTrades;
        }

        public MerchantOffer func_221182_a(Entity entity2, Random random) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_196153_dF);
            itemstack.func_77983_a("Explosion", (INBT)VillagerTradesHandler.createRandomFireworkStar(random));
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.price), itemstack, this.maxTrades, 1, 0.05f);
        }
    }

    static class RocketForEmeraldTrade
    implements VillagerTrades.ITrade {
        private final int maxTrades;
        private final int price;
        private final int paper;
        private final int rockets;

        public RocketForEmeraldTrade(int price, int paper, int rockets, int maxTrades) {
            this.price = price;
            this.maxTrades = maxTrades;
            this.paper = paper;
            this.rockets = rockets;
        }

        public MerchantOffer func_221182_a(Entity entity2, Random random) {
            ItemStack itemstack = new ItemStack((IItemProvider)Items.field_196152_dE, this.rockets);
            CompoundNBT compoundnbt = itemstack.func_190925_c("Fireworks");
            ListNBT listnbt = new ListNBT();
            int stars = 0;
            do {
                listnbt.add((Object)VillagerTradesHandler.createRandomFireworkStar(random));
            } while (random.nextFloat() < 0.42f && ++stars < 7);
            compoundnbt.func_74774_a("Flight", (byte)(random.nextInt(3) + 1));
            compoundnbt.func_218657_a("Explosions", (INBT)listnbt);
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.price), new ItemStack((IItemProvider)Items.field_151121_aF, this.paper), itemstack, this.maxTrades, 1, 0.05f);
        }
    }
}

