/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.selene.fluids.ISoftFluidHolder;
import net.mehvahdjukaar.selene.fluids.SoftFluidHolder;
import net.mehvahdjukaar.selene.util.Utils;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.ClockBlock;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.mobholder.IMobContainerProvider;
import net.mehvahdjukaar.supplementaries.common.mobholder.MobContainer;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.items.AbstractMobContainerItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishBucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class JarBlockTile
extends ItemDisplayTile
implements ITickableTileEntity,
IMobContainerProvider,
ISoftFluidHolder {
    private final int CAPACITY = ServerConfigs.cached.JAR_CAPACITY;
    @Nonnull
    public MobContainer mobContainer;
    public SoftFluidHolder fluidHolder = new SoftFluidHolder(this.CAPACITY);

    public JarBlockTile() {
        super((TileEntityType)ModRegistry.JAR_TILE.get());
        AbstractMobContainerItem item2 = (AbstractMobContainerItem)ModRegistry.JAR_ITEM.get();
        this.mobContainer = new MobContainer(item2.getMobContainerWidth(), item2.getMobContainerHeight(), this.field_145850_b, this.field_174879_c);
    }

    public void onLoad() {
        super.onLoad();
        this.mobContainer.setWorldAndPos(this.field_145850_b, this.field_174879_c);
    }

    public double func_145833_n() {
        return 80.0;
    }

    public void updateTileOnInventoryChanged() {
        this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        int light = this.fluidHolder.getFluid().getLuminosity();
        if (light != (Integer)this.func_195044_w().func_177229_b((Property)BlockProperties.LIGHT_LEVEL_0_15)) {
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    public boolean handleInteraction(PlayerEntity player, Hand hand) {
        ItemStack handStack = player.func_184586_b(hand);
        ItemStack displayedStack = this.getDisplayedItem();
        if (this.canInteractWithFluidHolder() && this.fluidHolder.interactWithPlayer(player, hand, this.field_145850_b, this.field_174879_c)) {
            return true;
        }
        if (this.mobContainer.isEmpty() && this.func_94041_b(0, handStack)) {
            this.handleAddItem(handStack, player, hand);
            return true;
        }
        if (this.func_191420_l() && this.fluidHolder.isEmpty() && this.mobContainer.interactWithBucket(handStack, player.field_70170_p, player.func_233580_cy_(), player, hand)) {
            return true;
        }
        if (!player.func_225608_bj_() && ServerConfigs.cached.JAR_EAT) {
            if (this.fluidHolder.tryDrinkUpFluid(player, this.field_145850_b)) {
                return true;
            }
            if (displayedStack.func_222117_E() && player.func_71043_e(false) && !player.func_184812_l_()) {
                player.func_213357_a(this.field_145850_b, displayedStack);
                return true;
            }
        }
        return this.handleExtractItem(player, hand);
    }

    public ItemStack extractItem() {
        ItemStack myStack = this.getDisplayedItem();
        if (myStack.func_190916_E() > 0) {
            return myStack.func_77979_a(1);
        }
        return ItemStack.field_190927_a;
    }

    public boolean handleExtractItem(PlayerEntity player, Hand hand) {
        if (this.getDisplayedItem().func_77973_b() instanceof FishBucketItem) {
            if (player.func_184586_b(hand).func_77973_b() != Items.field_151133_ar) {
                return false;
            }
            this.field_145850_b.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_203814_aa, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (!player.func_184586_b(hand).func_190926_b()) {
            return false;
        }
        ItemStack extracted = this.extractItem();
        if (!extracted.func_190926_b()) {
            Utils.swapItem((PlayerEntity)player, (Hand)hand, (ItemStack)extracted);
            return true;
        }
        return false;
    }

    public void handleAddItem(ItemStack stack, @Nullable PlayerEntity player, Hand handIn) {
        ItemStack handStack = stack.func_77946_l();
        handStack.func_190920_e(1);
        Item item2 = handStack.func_77973_b();
        this.addItem(handStack);
        if (player != null) {
            ItemStack returnStack = ItemStack.field_190927_a;
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)item2));
            if (!player.func_184812_l_()) {
                Utils.swapItem((PlayerEntity)player, (Hand)handIn, (ItemStack)returnStack);
            }
        }
    }

    public void addItem(ItemStack itemstack) {
        if (this.func_191420_l()) {
            NonNullList stacks = NonNullList.func_191197_a((int)1, (Object)itemstack);
            this.func_199721_a(stacks);
        } else {
            this.getDisplayedItem().func_190917_f(Math.min(1, this.func_70297_j_() - this.getDisplayedItem().func_190916_E()));
        }
    }

    public void resetHolders() {
        this.fluidHolder.clear();
        this.mobContainer = null;
        this.setDisplayedItem(ItemStack.field_190927_a);
    }

    public boolean isPonyJar() {
        if (this.func_145818_k_()) {
            ITextComponent c = this.func_200201_e();
            return c != null && c.getString().contains("cum");
        }
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (this.fluidHolder.isEmpty() && this.mobContainer.isEmpty()) {
            Item i = stack.func_77973_b();
            if (!this.isFull() && CommonUtil.isCookie(i)) {
                return this.func_191420_l() || i == this.getDisplayedItem().func_77973_b();
            }
        }
        return false;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.fluidHolder.load(compound);
        this.mobContainer.load(compound);
        if (this.field_145850_b != null) {
            // empty if block
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.fluidHolder.save(compound);
        this.mobContainer.save(compound);
        return compound;
    }

    public boolean hasContent() {
        return !this.func_191420_l() || !this.mobContainer.isEmpty() || !this.fluidHolder.isEmpty();
    }

    public boolean isFull() {
        return this.getDisplayedItem().func_190916_E() >= this.func_70297_j_();
    }

    public int func_70297_j_() {
        return this.CAPACITY;
    }

    public ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.supplementaries.jar");
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return CommonUtil.isCookie(stack.func_77973_b()) && (this.func_191420_l() || stack.func_77973_b() == this.getDisplayedItem().func_77973_b());
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    @Override
    public MobContainer getMobContainer() {
        return this.mobContainer;
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)ClockBlock.FACING);
    }

    public void func_73660_a() {
        this.mobContainer.tick();
    }

    public SoftFluidHolder getSoftFluidHolder() {
        return this.fluidHolder;
    }

    public boolean canInteractWithFluidHolder() {
        return this.func_191420_l() && (this.mobContainer.isEmpty() || this.isPonyJar());
    }
}

