/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.client.gui.SpeakerBlockGui;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.SendSpeakerBlockMessagePacket;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class SpeakerBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public SpeakerBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.updatePower(state, worldIn, pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof SpeakerBlockTile) {
            if (stack.func_82837_s()) {
                ((SpeakerBlockTile)tileentity).setCustomName(stack.func_200301_q());
            }
            BlockUtils.addOptionalOwnership(placer, tileentity);
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.func_220069_a(state, world, pos, neighborBlock, fromPos, moving);
        this.updatePower(state, world, pos);
    }

    public void updatePower(BlockState state, World world, BlockPos pos) {
        boolean pow;
        if (!world.func_201670_d() && (pow = world.func_175640_z(pos)) != (Boolean)state.func_177229_b((Property)POWERED)) {
            TileEntity tileentity;
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(pow)), 3);
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            if (pow && world.func_175623_d(pos.func_177972_a(facing)) && (tileentity = world.func_175625_s(pos)) instanceof SpeakerBlockTile) {
                SpeakerBlockTile speaker = (SpeakerBlockTile)tileentity;
                MinecraftServer mcserv = ServerLifecycleHooks.getCurrentServer();
                RegistryKey dimension = world.func_234923_W_();
                if (mcserv != null && !speaker.message.equals("")) {
                    world.func_175641_c(pos, (Block)this, 0, 0);
                    PlayerList players = mcserv.func_184103_al();
                    IFormattableTextComponent message = new StringTextComponent(speaker.func_200200_C_().getString() + ": " + speaker.message).func_240699_a_(TextFormatting.ITALIC);
                    players.func_148543_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)ServerConfigs.cached.SPEAKER_RANGE * speaker.volume, dimension, NetworkHandler.INSTANCE.toVanillaPacket((Object)new SendSpeakerBlockMessagePacket((ITextComponent)message, speaker.narrator), NetworkDirection.PLAY_TO_CLIENT));
                }
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity entity2, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof SpeakerBlockTile && ((IOwnerProtected)tileentity).isAccessibleBy(entity2)) {
            if (world.field_72995_K) {
                SpeakerBlockGui.open((SpeakerBlockTile)tileentity);
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SpeakerBlockTile();
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
        if (eventID == 0) {
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            world.func_195594_a((IParticleData)ModRegistry.SPEAKER_SOUND.get(), (double)pos.func_177958_n() + 0.5 + (double)facing.func_82601_c() * 0.725, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (double)facing.func_82599_e() * 0.725, (double)world.field_73012_v.nextInt(24) / 24.0, 0.0, 0.0);
            return true;
        }
        return super.func_189539_a(state, world, pos, eventID, eventParam);
    }
}

