/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.BlockUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class JarBlock
extends WaterBlock {
    protected static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.875, (double)0.8125), (VoxelShape)VoxelShapes.func_197873_a((double)0.3125, (double)0.875, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875));
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final IntegerProperty LIGHT_LEVEL = BlockProperties.LIGHT_LEVEL_0_15;

    public JarBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getJarLiquidColor(BlockPos pos, IWorldReader world) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof JarBlockTile) {
            return ((JarBlockTile)te).fluidHolder.getParticleColor(world, pos);
        }
        return 0xFFFFFF;
    }

    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        int color = this.getJarLiquidColor(pos, world);
        if (color == -1) {
            return null;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof JarBlockTile && ((IOwnerProtected)tileentity).isAccessibleBy(player)) {
            JarBlockTile te = (JarBlockTile)tileentity;
            if (te.handleInteraction(player, handIn)) {
                if (!worldIn.func_201670_d()) {
                    te.func_70296_d();
                }
                return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            }
            return ((JarBlockTile)tileentity).mobContainer.onInteract(worldIn, pos, player, handIn);
        }
        return ActionResultType.PASS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof JarBlockTile) {
            if (stack.func_82837_s()) {
                ((JarBlockTile)tileentity).func_213903_a(stack.func_200301_q());
            }
            BlockUtils.addOptionalOwnership(placer, tileentity);
        }
    }

    public ItemStack getJarItem(JarBlockTile te) {
        ItemStack returnStack = new ItemStack((IItemProvider)this);
        if (te.hasContent()) {
            CompoundNBT compoundnbt = te.func_189515_b(new CompoundNBT());
            if (compoundnbt.func_74764_b("Owner")) {
                compoundnbt.func_82580_o("Owner");
            }
            if (!compoundnbt.isEmpty()) {
                returnStack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
            }
        }
        if (te.func_145818_k_()) {
            returnStack.func_200302_a(te.func_200201_e());
        }
        return returnStack;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof JarBlockTile) {
            JarBlockTile tile = (JarBlockTile)tileentity;
            ItemStack itemstack = this.getJarItem(tile);
            return Collections.singletonList(itemstack);
        }
        return super.func_220076_a(state, builder);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof JarBlockTile) {
            JarBlockTile tile = (JarBlockTile)tileentity;
            return this.getJarItem(tile);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIGHT_LEVEL, FACING, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new JarBlockTile();
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Integer)state.func_177229_b((Property)LIGHT_LEVEL);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof JarBlockTile) {
            JarBlockTile te = (JarBlockTile)tileentity;
            if (!te.func_191420_l()) {
                return Container.func_94526_b((IInventory)te);
            }
            if (!te.fluidHolder.isEmpty()) {
                return ((JarBlockTile)tileentity).fluidHolder.getComparatorOutput();
            }
            if (!te.mobContainer.isEmpty()) {
                return 15;
            }
        }
        return 0;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }
}

