/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TextRenderUtils {
    private TextRenderUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    private static void render(MatrixStack matrix, FontRenderer fontRenderer, IReorderingProcessor text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            fontRenderer.func_238407_a_(matrix, text, x, y, color);
        } else {
            fontRenderer.func_238422_b_(matrix, text, x, y, color);
        }
    }

    public static void renderScaled(MatrixStack matrix, FontRenderer fontRenderer, IReorderingProcessor text, int x, int y, float scale, int color, boolean shadow) {
        matrix.func_227860_a_();
        matrix.func_227862_a_(scale, scale, scale);
        TextRenderUtils.render(matrix, fontRenderer, text, (float)x / scale, (float)y / scale, color, shadow);
        matrix.func_227865_b_();
    }

    public static void renderSplit(MatrixStack matrix, FontRenderer fontRenderer, ITextProperties text, int x, int y, int width, int color, boolean shadow) {
        List list = fontRenderer.func_238425_b_(text, width);
        for (int i = 0; i < list.size(); ++i) {
            IReorderingProcessor line = (IReorderingProcessor)list.get(i);
            fontRenderer.getClass();
            int yTranslated = y + i * 9;
            TextRenderUtils.render(matrix, fontRenderer, line, x, yTranslated, color, shadow);
        }
    }

    public static void renderSplitScaled(MatrixStack matrix, FontRenderer fontRenderer, ITextProperties text, int x, int y, float scale, int color, boolean shadow, int length) {
        List lines = fontRenderer.func_238425_b_(text, (int)((float)length / scale));
        for (int i = 0; i < lines.size(); ++i) {
            fontRenderer.getClass();
            int yTranslated = y + i * (int)(9.0f * scale + 3.0f);
            TextRenderUtils.renderScaled(matrix, fontRenderer, (IReorderingProcessor)lines.get(i), x, yTranslated, scale, color, shadow);
        }
    }
}

