/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.quark;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.supplementaries.block.tiles.SackBlockTile;
import net.mehvahdjukaar.supplementaries.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.inventories.SackContainer;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.content.client.module.ChestSearchingModule;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;
import vazkii.quark.content.client.tooltip.ShulkerBoxTooltips;

public class QuarkTooltipPlugin {
    private static final SackBlockTile DUMMY_SACK_TILE = new SackBlockTile();
    private static final BlockState DEFAULT_SACK = ((Block)ModRegistry.SACK.get()).func_176223_P();
    private static final SafeBlockTile DUMMY_SAFE_TILE = new SafeBlockTile();
    private static final BlockState DEFAULT_SAFE = ((Block)ModRegistry.SAFE.get()).func_176223_P();
    private static final int CORNER = 5;
    private static final int EDGE = 18;

    public static boolean canRenderTooltip() {
        return !ImprovedTooltipsModule.shulkerBoxRequireShift || Screen.func_231173_s_();
    }

    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStack stack;
        CompoundNBT cmp;
        if (QuarkTooltipPlugin.canRenderTooltip() && (cmp = ItemNBTHelper.getCompound((ItemStack)(stack = event.getItemStack()), (String)"BlockEntityTag", (boolean)true)) != null && !cmp.func_74764_b("LootTable")) {
            Item i = stack.func_77973_b();
            if (i == ModRegistry.SAFE_ITEM.get()) {
                DUMMY_SAFE_TILE.func_230337_a_(DEFAULT_SAFE, cmp);
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player == null || DUMMY_SAFE_TILE.canPlayerOpen((PlayerEntity)Minecraft.func_71410_x().field_71439_g, false)) {
                    QuarkTooltipPlugin.cleanupTooltip(event.getToolTip());
                }
            } else if (i == ModRegistry.SACK_ITEM.get()) {
                QuarkTooltipPlugin.cleanupTooltip(event.getToolTip());
            }
        }
    }

    public static void renderTooltipEvent(RenderTooltipEvent.PostText event) {
        ItemStack stack;
        CompoundNBT cmp;
        if (QuarkTooltipPlugin.canRenderTooltip() && (cmp = ItemNBTHelper.getCompound((ItemStack)(stack = event.getStack()), (String)"BlockEntityTag", (boolean)true)) != null && !cmp.func_74764_b("LootTable")) {
            Item i = stack.func_77973_b();
            if (i == ModRegistry.SAFE_ITEM.get()) {
                DUMMY_SAFE_TILE.func_230337_a_(DEFAULT_SAFE, cmp);
                ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
                if (player == null || DUMMY_SAFE_TILE.canPlayerOpen((PlayerEntity)Minecraft.func_71410_x().field_71439_g, false)) {
                    QuarkTooltipPlugin.doRenderTooltip(event, DUMMY_SAFE_TILE, DUMMY_SAFE_TILE.func_70302_i_());
                }
            } else if (i == ModRegistry.SACK_ITEM.get()) {
                DUMMY_SACK_TILE.func_230337_a_(DEFAULT_SACK, cmp);
                QuarkTooltipPlugin.doRenderTooltip(event, DUMMY_SACK_TILE, DUMMY_SACK_TILE.getUnlockedSlots());
            }
        }
    }

    private static void cleanupTooltip(List<ITextComponent> tooltip) {
        ArrayList<ITextComponent> tooltipCopy = new ArrayList<ITextComponent>(tooltip);
        for (int i = 1; i < tooltipCopy.size(); ++i) {
            ITextComponent t = (ITextComponent)tooltipCopy.get(i);
            String s = t.getString();
            if (s.startsWith("\u00c2\u00a7") && !s.startsWith("\u00c2\u00a7o")) continue;
            tooltip.remove(t);
        }
        if (ImprovedTooltipsModule.shulkerBoxRequireShift && !Screen.func_231173_s_()) {
            tooltip.add(1, (ITextComponent)new TranslationTextComponent("quark.misc.shulker_box_shift"));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void doRenderTooltip(RenderTooltipEvent.PostText event, LockableLootTileEntity container, int size) {
        container.func_189404_a(null, 0L);
        LazyOptional handler = container.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        handler.ifPresent(capability -> {
            MainWindow window;
            int right;
            Minecraft mc = Minecraft.func_71410_x();
            MatrixStack matrix = event.getMatrixStack();
            int[] dims = SackContainer.getRatio(size);
            int currentX = event.getX() - 5;
            int currentY = event.getY() - 16 - 18 * dims[1];
            int texWidth = 10 + 18 * dims[0];
            if (currentY < 0) {
                currentY = event.getY() + event.getLines().size() * 10 + 5;
            }
            if ((right = currentX + texWidth) > (window = mc.func_228018_at_()).func_198107_o()) {
                currentX -= right - window.func_198107_o();
            }
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)700.0f);
            int color = -1;
            ShulkerBoxTooltips.renderTooltipBackground((Minecraft)mc, (MatrixStack)matrix, (int)currentX, (int)currentY, (int)dims[0], (int)dims[1], (int)color);
            ItemRenderer render = mc.func_175599_af();
            for (int i = 0; i < size; ++i) {
                ItemStack itemstack = capability.getStackInSlot(i);
                int xp = currentX + 6 + i % dims[0] * 18;
                int yp = currentY + 6 + i / dims[0] * 18;
                if (!itemstack.func_190926_b()) {
                    render.func_239390_c_(itemstack, xp, yp);
                    render.func_175030_a(mc.field_71466_p, itemstack, xp, yp);
                }
                if (ChestSearchingModule.namesMatch((ItemStack)itemstack)) continue;
                RenderSystem.disableDepthTest();
                AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)-1442840576);
            }
            RenderSystem.popMatrix();
        });
    }
}

