/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.models;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.MimicBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.WallLanternBlock;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import org.jetbrains.annotations.NotNull;

public class WallLanternBakedModel
implements IDynamicBakedModel {
    private final IBakedModel support;
    private final BlockModelShapes blockModelShaper;

    public WallLanternBakedModel(IBakedModel support) {
        this.support = support;
        this.blockModelShaper = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        try {
            quads.addAll(this.support.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            BlockState mimic;
            boolean fancy = Boolean.TRUE.equals(extraData.getData(BlockProperties.FANCY));
            if (!(fancy || (mimic = (BlockState)extraData.getData(BlockProperties.MIMIC)) == null || mimic.func_177230_c() instanceof MimicBlock || mimic.func_196958_f() || state == null)) {
                Direction dir = (Direction)state.func_177229_b((Property)WallLanternBlock.FACING);
                if (mimic.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
                    mimic = (BlockState)mimic.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)dir);
                } else if (mimic.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                    mimic = (BlockState)mimic.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)dir);
                }
                IBakedModel model = this.blockModelShaper.func_178125_b(mimic);
                List mimicQuads = model.getQuads(mimic, side, rand, (IModelData)EmptyModelData.INSTANCE);
                TextureAtlasSprite texture = this.func_177554_e();
                for (BakedQuad q : mimicQuads) {
                    int[] v = Arrays.copyOf(q.func_178209_a(), q.func_178209_a().length);
                    RendererUtil.moveVertices(v, Direction.UP, 0.125f, texture);
                    RendererUtil.moveVertices(v, dir, -0.125f, texture);
                    quads.add(new BakedQuad(v, q.func_178211_c(), q.func_178210_d(), q.func_187508_a(), q.func_239287_f_()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.support.func_177554_e();
    }

    public TextureAtlasSprite getParticleTexture(@NotNull IModelData data) {
        BlockState mimic = (BlockState)data.getData(BlockProperties.MIMIC);
        if (mimic != null && !mimic.func_196958_f()) {
            IBakedModel model = this.blockModelShaper.func_178125_b(mimic);
            try {
                return model.func_177554_e();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.func_177554_e();
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    private void putVertex(BakedQuadBuilder builder, Vector3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = builder.getVertexFormat().func_227894_c_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.func_177369_e()) {
                        case 0: {
                            float iu = sprite.func_94214_a((double)u);
                            float iv = sprite.func_94207_b((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite) {
        Vector3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        int tw = sprite.func_94211_a();
        int th = sprite.func_94216_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, th, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, tw, th, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, tw, 0.0f, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    private static Vector3d v(double x, double y, double z) {
        return new Vector3d(x, y, z);
    }
}

