/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper;

import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.tags.ITag;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockToolSwapUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEntityToolSwapUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.SwordRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ToolRegistry;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapMode;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperFilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.toolswapper.ToolSwapperUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class ToolSwapperUpgradeWrapper
extends UpgradeWrapperBase<ToolSwapperUpgradeWrapper, ToolSwapperUpgradeItem>
implements IBlockClickResponseUpgrade,
IAttackEntityResponseUpgrade,
IBlockToolSwapUpgrade,
IEntityToolSwapUpgrade {
    private static final ToolType SWORD_TOOL_TYPE = ToolType.get((String)"sword");
    private final ToolSwapperFilterLogic filterLogic;
    @Nullable
    private ResourceLocation toolCacheFor = null;
    private final Queue<ItemStack> toolCache = new LinkedList<ItemStack>();

    protected ToolSwapperUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ToolSwapperFilterLogic(upgrade, upgradeSaveHandler);
    }

    @Override
    public boolean onBlockClick(PlayerEntity player, BlockPos pos) {
        Block block;
        ToolSwapMode toolSwapMode = this.getToolSwapMode();
        if (player.func_184812_l_() || player.func_175149_v() || toolSwapMode == ToolSwapMode.NO_SWAP) {
            return false;
        }
        ItemStack mainHandItem = player.func_184614_ca();
        if (mainHandItem.func_77973_b() instanceof BackpackItem || toolSwapMode == ToolSwapMode.ONLY_TOOLS && this.isSword(mainHandItem, player) || !this.isSword(mainHandItem, player) && !this.isTool(mainHandItem)) {
            return false;
        }
        BlockState state = player.field_70170_p.func_180495_p(pos);
        if (this.getToolTypeEffectiveOnBlock(state, block = state.func_177230_c(), mainHandItem).isPresent() || this.goodAtBreakingBlock(state, mainHandItem)) {
            return true;
        }
        return this.tryToSwapTool(player, state, block, mainHandItem);
    }

    private boolean tryToSwapTool(PlayerEntity player, BlockState state, Block block, ItemStack mainHandItem) {
        AtomicReference<ItemStack> selectedTool = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        AtomicInteger selectedSlot = new AtomicInteger(-1);
        AtomicBoolean finished = new AtomicBoolean(false);
        BackpackInventoryHandler backpackInventory = this.backpackWrapper.getInventoryHandler();
        InventoryHelper.iterate((IItemHandler)backpackInventory, (slot, stack) -> {
            if (stack.func_190926_b()) {
                return;
            }
            if (this.isAllowedAndGoodAtBreakingBlock(state, block, (ItemStack)stack)) {
                selectedSlot.set((int)slot);
                selectedTool.set((ItemStack)stack);
                if (!(block instanceof LeavesBlock) || !this.getToolTypes((ItemStack)stack).contains(ToolType.HOE)) {
                    finished.set(true);
                }
            }
        }, finished::get);
        ItemStack tool = selectedTool.get();
        if (!tool.func_190926_b() && (tool.func_190916_E() == 1 || InventoryHelper.insertIntoInventory(mainHandItem, (IItemHandler)backpackInventory, true).func_190926_b())) {
            player.func_184611_a(Hand.MAIN_HAND, backpackInventory.extractItem(selectedSlot.get(), 1, false));
            InventoryHelper.insertIntoInventory(mainHandItem, (IItemHandler)backpackInventory, false);
            return true;
        }
        return false;
    }

    private boolean isAllowedAndGoodAtBreakingBlock(BlockState state, Block block, ItemStack stack) {
        return this.getToolTypeEffectiveOnBlock(state, block, stack).map(toolType -> this.filterLogic.matchesToolFilter(stack, (ToolType)toolType)).orElse(false) != false || this.goodAtBreakingBlock(state, stack);
    }

    private boolean goodAtBreakingBlock(BlockState state, ItemStack stack) {
        return stack.func_150998_b(state) && (double)stack.func_150997_a(state) > 1.5;
    }

    private Optional<ToolType> getToolTypeEffectiveOnBlock(BlockState state, Block block, ItemStack stack) {
        for (ToolType type : this.getToolTypes(stack)) {
            if (!block.isToolEffective(state, type)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    private Set<ToolType> getToolTypes(ItemStack stack) {
        Set toolTypes = stack.getToolTypes();
        if (toolTypes.isEmpty()) {
            return ToolRegistry.getItemToolTypes(stack);
        }
        return toolTypes;
    }

    @Override
    public boolean onAttackEntity(PlayerEntity player) {
        if (!this.shouldSwapWeapon()) {
            return false;
        }
        ItemStack mainHandItem = player.func_184614_ca();
        if (this.isSword(mainHandItem, player)) {
            return true;
        }
        if (mainHandItem.func_77973_b() instanceof BackpackItem || !this.isTool(mainHandItem)) {
            return false;
        }
        if (this.filterLogic.isAllowList()) {
            BackpackInventoryHandler backpackInventory = this.backpackWrapper.getInventoryHandler();
            AtomicBoolean result = new AtomicBoolean(false);
            InventoryHelper.iterate((IItemHandler)backpackInventory, (slot, stack) -> {
                if (this.filterLogic.matchesWeaponFilter((ItemStack)stack)) {
                    result.set(this.swapWeapon(player, mainHandItem, (IItemHandlerModifiable)backpackInventory, (ItemStack)stack));
                }
            });
            return result.get();
        }
        return this.tryToSwapInWeapon(player, mainHandItem);
    }

    private boolean isTool(ItemStack stack) {
        return !stack.getToolTypes().isEmpty() || !ToolRegistry.getItemToolTypes(stack).isEmpty() || stack.func_77973_b() instanceof ShearsItem || stack.func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS);
    }

    private boolean isSword(ItemStack stack, PlayerEntity player) {
        if (SwordRegistry.isSword(stack)) {
            return true;
        }
        ModifiableAttributeInstance attackDamage = player.func_110148_a(Attributes.field_233823_f_);
        if (!stack.func_190926_b() && this.hasSwordOrNoToolTypes(stack)) {
            return attackDamage != null && attackDamage.func_111127_a(Item.field_111210_e) != null;
        }
        return false;
    }

    private boolean tryToSwapInWeapon(PlayerEntity player, ItemStack mainHandItem) {
        AtomicReference<ItemStack> bestAxe = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        AtomicDouble bestAxeDamage = new AtomicDouble(0.0);
        AtomicReference<ItemStack> bestSword = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        AtomicDouble bestSwordDamage = new AtomicDouble(0.0);
        this.updateBestWeapons(bestAxe, bestAxeDamage, bestSword, bestSwordDamage, mainHandItem);
        BackpackInventoryHandler backpackInventory = this.backpackWrapper.getInventoryHandler();
        InventoryHelper.iterate((IItemHandler)backpackInventory, (slot, stack) -> {
            if (this.filterLogic.matchesWeaponFilter((ItemStack)stack)) {
                this.updateBestWeapons(bestAxe, bestAxeDamage, bestSword, bestSwordDamage, (ItemStack)stack);
            }
        });
        if (!bestSword.get().func_190926_b()) {
            return this.swapWeapon(player, mainHandItem, (IItemHandlerModifiable)backpackInventory, bestSword.get());
        }
        if (!bestAxe.get().func_190926_b()) {
            return this.swapWeapon(player, mainHandItem, (IItemHandlerModifiable)backpackInventory, bestAxe.get());
        }
        return false;
    }

    private void updateBestWeapons(AtomicReference<ItemStack> bestAxe, AtomicDouble bestAxeDamage, AtomicReference<ItemStack> bestSword, AtomicDouble bestSwordDamage, ItemStack stack) {
        ModifiableAttributeInstance attribute = new ModifiableAttributeInstance(Attributes.field_233823_f_, a -> {});
        Multimap attributeModifiers = stack.func_111283_C(EquipmentSlotType.MAINHAND);
        if (!attributeModifiers.containsKey((Object)Attributes.field_233823_f_)) {
            return;
        }
        attributeModifiers.get((Object)Attributes.field_233823_f_).forEach(m -> {
            attribute.func_111124_b(m);
            attribute.func_233767_b_(m);
        });
        double damageValue = attribute.func_111126_e();
        if (this.getToolTypes(stack).contains(ToolType.AXE)) {
            if (damageValue > bestAxeDamage.get()) {
                bestAxe.set(stack);
                bestAxeDamage.set(damageValue);
            }
        } else if ((SwordRegistry.isSword(stack) || this.hasSwordOrNoToolTypes(stack)) && damageValue > bestSwordDamage.get()) {
            bestSword.set(stack);
            bestSwordDamage.set(damageValue);
        }
    }

    private boolean hasSwordOrNoToolTypes(ItemStack stack) {
        Set<ToolType> toolTypes = this.getToolTypes(stack);
        return toolTypes.isEmpty() || toolTypes.contains(SWORD_TOOL_TYPE);
    }

    private boolean swapWeapon(PlayerEntity player, ItemStack mainHandItem, IItemHandlerModifiable backpackInventory, ItemStack sword) {
        if (sword == mainHandItem) {
            return true;
        }
        InventoryHelper.extractFromInventory(sword, (IItemHandler)backpackInventory, false);
        if (InventoryHelper.insertIntoInventory(mainHandItem, (IItemHandler)backpackInventory, true).func_190926_b()) {
            player.func_184611_a(Hand.MAIN_HAND, sword);
            InventoryHelper.insertIntoInventory(mainHandItem, (IItemHandler)backpackInventory, false);
            return true;
        }
        InventoryHelper.insertIntoInventory(sword, (IItemHandler)backpackInventory, false);
        return false;
    }

    @Override
    public boolean hideSettingsTab() {
        return !((ToolSwapperUpgradeItem)this.upgradeItem).hasSettingsTab();
    }

    public ToolSwapperFilterLogic getFilterLogic() {
        return this.filterLogic;
    }

    public boolean shouldSwapWeapon() {
        return NBTHelper.getBoolean(this.upgrade, "shouldSwapWeapon").orElse(true);
    }

    public void setSwapWeapon(boolean shouldSwapWeapon) {
        NBTHelper.setBoolean(this.upgrade, "shouldSwapWeapon", shouldSwapWeapon);
        this.save();
    }

    public ToolSwapMode getToolSwapMode() {
        return NBTHelper.getEnumConstant(this.upgrade, "toolSwapMode", ToolSwapMode::fromName).orElse(ToolSwapMode.ANY);
    }

    public void setToolSwapMode(ToolSwapMode toolSwapMode) {
        NBTHelper.setEnumConstant(this.upgrade, "toolSwapMode", toolSwapMode);
        this.save();
    }

    @Override
    public boolean onEntityInteract(World world, Entity entity, PlayerEntity player) {
        if (!((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress()) {
            return false;
        }
        return this.tryToSwapTool(player, stack -> this.itemWorksOnEntity((ItemStack)stack, entity), entity.func_200600_R().getRegistryName());
    }

    private boolean itemWorksOnEntity(ItemStack stack, Entity entity) {
        if (this.isShearableEntity(entity, stack) && this.isShearsItem(stack)) {
            return true;
        }
        return ToolRegistry.isToolForEntity(stack, entity);
    }

    @Override
    public boolean onBlockInteract(World world, BlockPos pos, BlockState blockState, PlayerEntity player) {
        if (!((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress()) {
            return false;
        }
        return this.tryToSwapTool(player, stack -> this.itemWorksOnBlock(world, pos, blockState, player, (ItemStack)stack), blockState.func_177230_c().getRegistryName());
    }

    private boolean tryToSwapTool(PlayerEntity player, Predicate<ItemStack> isToolValid, @Nullable ResourceLocation targetRegistryName) {
        ItemStack tool;
        ItemStack mainHandStack = player.func_184614_ca();
        if (mainHandStack.func_77973_b() instanceof BackpackItem) {
            return false;
        }
        if (this.toolCacheFor == null || !this.toolCacheFor.equals((Object)targetRegistryName)) {
            this.toolCache.clear();
            this.toolCacheFor = targetRegistryName;
        }
        boolean itemInHandIsValid = isToolValid.test(mainHandStack);
        BackpackInventoryHandler backpackInventory = this.backpackWrapper.getInventoryHandler();
        if (itemInHandIsValid && this.toolCache.stream().noneMatch(st -> ItemStack.func_185132_d((ItemStack)st, (ItemStack)mainHandStack))) {
            this.toolCache.offer(mainHandStack);
        }
        if ((tool = this.findToolToSwap(backpackInventory, isToolValid)).func_190926_b()) {
            return false;
        }
        if ((tool = tool.func_77946_l().func_77979_a(1)).func_190916_E() == 1 || InventoryHelper.insertIntoInventory(mainHandStack, (IItemHandler)backpackInventory, true).func_190926_b()) {
            player.func_184611_a(Hand.MAIN_HAND, InventoryHelper.extractFromInventory(tool, (IItemHandler)backpackInventory, false));
            InventoryHelper.insertIntoInventory(mainHandStack, (IItemHandler)backpackInventory, false);
            this.toolCache.offer(tool);
        }
        return true;
    }

    private ItemStack findToolToSwap(BackpackInventoryHandler backpackInventory, Predicate<ItemStack> isValidTool) {
        HashSet<ItemStack> alreadyGivenBefore = new HashSet<ItemStack>();
        AtomicReference<ItemStack> toolFound = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
        InventoryHelper.iterate((IItemHandler)backpackInventory, (slot, stack) -> {
            if (stack.func_190926_b()) {
                return;
            }
            if (!this.hasEquivalentItem((Collection<ItemStack>)this.toolCache, (ItemStack)stack)) {
                if (isValidTool.test((ItemStack)stack)) {
                    toolFound.set((ItemStack)stack);
                }
            } else {
                alreadyGivenBefore.add((ItemStack)stack);
            }
        }, () -> !((ItemStack)toolFound.get()).func_190926_b());
        if (toolFound.get().func_190926_b() && !alreadyGivenBefore.isEmpty()) {
            while (this.toolCache.peek() != null) {
                ItemStack itemStack = this.toolCache.poll();
                if (!this.hasEquivalentItem(alreadyGivenBefore, itemStack)) continue;
                toolFound.set(itemStack);
                break;
            }
        }
        return toolFound.get();
    }

    private boolean hasEquivalentItem(Collection<ItemStack> alreadyGivenBefore, ItemStack stack) {
        for (ItemStack givenTool : alreadyGivenBefore) {
            if (!ItemStack.func_185132_d((ItemStack)givenTool, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    private boolean itemWorksOnBlock(World world, BlockPos pos, BlockState blockState, PlayerEntity player, ItemStack stack) {
        for (ToolType toolType : this.getToolTypes(stack)) {
            if (blockState.getToolModifiedState(world, pos, player, stack, toolType) == null) continue;
            return true;
        }
        Block block = blockState.func_177230_c();
        if (this.isShearInteractionBlock(world, pos, stack, block) && this.isShearsItem(stack)) {
            return true;
        }
        return ToolRegistry.isToolForBlock(stack, block, world, blockState, pos);
    }

    private boolean isShearsItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ShearsItem || stack.func_77973_b().func_206844_a((ITag)Tags.Items.SHEARS);
    }

    private boolean isShearInteractionBlock(World world, BlockPos pos, ItemStack stack, Block block) {
        return block instanceof IForgeShearable && ((IForgeShearable)block).isShearable(stack, world, pos) || block instanceof BeehiveBlock;
    }

    private boolean isShearableEntity(Entity entity, ItemStack stack) {
        return entity instanceof IForgeShearable && ((IForgeShearable)entity).isShearable(stack, entity.field_70170_p, entity.func_233580_cy_());
    }

    @Override
    public boolean canProcessBlockInteract() {
        return ((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress();
    }

    @Override
    public boolean canProcessEntityInteract() {
        return ((ToolSwapperUpgradeItem)this.upgradeItem).shouldSwapToolOnKeyPress();
    }
}

