/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;

public class FilteredItemHandler<T extends IItemHandler>
implements IItemHandler {
    protected final T inventoryHandler;
    private final List<FilterLogic> inputFilters;
    private final List<FilterLogic> outputFilters;

    public FilteredItemHandler(T inventoryHandler, List<FilterLogic> inputFilters, List<FilterLogic> outputFilters) {
        this.inventoryHandler = inventoryHandler;
        this.inputFilters = inputFilters;
        this.outputFilters = outputFilters;
    }

    public int getSlots() {
        return this.inventoryHandler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventoryHandler.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.inputFilters.isEmpty()) {
            return this.inventoryHandler.insertItem(slot, stack, simulate);
        }
        for (FilterLogic filter : this.inputFilters) {
            if (!filter.matchesFilter(stack)) continue;
            return this.inventoryHandler.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.outputFilters.isEmpty()) {
            return this.inventoryHandler.extractItem(slot, amount, simulate);
        }
        for (FilterLogic filter : this.outputFilters) {
            if (!filter.matchesFilter(this.getStackInSlot(slot))) continue;
            return this.inventoryHandler.extractItem(slot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.inventoryHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.inventoryHandler.isItemValid(slot, stack);
    }

    public static class Modifiable
    extends FilteredItemHandler<IItemHandlerModifiable>
    implements IItemHandlerModifiable {
        public Modifiable(IItemHandlerModifiable inventoryHandler, List<FilterLogic> inputFilters, List<FilterLogic> outputFilters) {
            super(inventoryHandler, inputFilters, outputFilters);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ((IItemHandlerModifiable)this.inventoryHandler).setStackInSlot(slot, stack);
        }
    }
}

