/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.init;

import cofh.core.block.TileBlockActive;
import cofh.core.block.TileBlockActive4Way;
import cofh.core.block.TileBlockCoFH;
import cofh.core.item.BlockItemCoFH;
import cofh.lib.block.impl.GunpowderBlock;
import cofh.lib.block.impl.HardenedGlassBlock;
import cofh.lib.block.impl.OreBlockCoFH;
import cofh.lib.block.impl.RubberBlock;
import cofh.lib.block.impl.TNTBlockCoFH;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.BlockHelper;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.block.EnderiumBlock;
import cofh.thermal.core.block.EnderiumGlassBlock;
import cofh.thermal.core.block.LumiumBlock;
import cofh.thermal.core.block.LumiumGlassBlock;
import cofh.thermal.core.block.SignalumBlock;
import cofh.thermal.core.block.SignalumGlassBlock;
import cofh.thermal.core.entity.item.EarthTNTEntity;
import cofh.thermal.core.entity.item.EnderTNTEntity;
import cofh.thermal.core.entity.item.FireTNTEntity;
import cofh.thermal.core.entity.item.GlowstoneTNTEntity;
import cofh.thermal.core.entity.item.IceTNTEntity;
import cofh.thermal.core.entity.item.LightningTNTEntity;
import cofh.thermal.core.entity.item.NukeTNTEntity;
import cofh.thermal.core.entity.item.PhytoTNTEntity;
import cofh.thermal.core.entity.item.RedstoneTNTEntity;
import cofh.thermal.core.entity.item.SlimeTNTEntity;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.core.item.EnergyCellBlockItem;
import cofh.thermal.core.item.FluidCellBlockItem;
import cofh.thermal.core.tileentity.ChargeBenchTile;
import cofh.thermal.core.tileentity.TinkerBenchTile;
import cofh.thermal.core.tileentity.device.DeviceCollectorTile;
import cofh.thermal.core.tileentity.device.DeviceFisherTile;
import cofh.thermal.core.tileentity.device.DeviceHiveExtractorTile;
import cofh.thermal.core.tileentity.device.DeviceNullifierTile;
import cofh.thermal.core.tileentity.device.DevicePotionDiffuserTile;
import cofh.thermal.core.tileentity.device.DeviceRockGenTile;
import cofh.thermal.core.tileentity.device.DeviceSoilInfuserTile;
import cofh.thermal.core.tileentity.device.DeviceTreeExtractorTile;
import cofh.thermal.core.tileentity.device.DeviceWaterGenTile;
import cofh.thermal.core.tileentity.storage.EnergyCellTile;
import cofh.thermal.core.tileentity.storage.FluidCellTile;
import cofh.thermal.core.util.RegistrationHelper;
import cofh.thermal.lib.block.TileBlockCell;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalItemGroups;
import java.util.function.IntSupplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SandBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.Rarity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;

public class TCoreBlocks {
    private TCoreBlocks() {
    }

    public static void register() {
        TCoreBlocks.registerVanilla();
        TCoreBlocks.registerResources();
        TCoreBlocks.registerStorage();
        TCoreBlocks.registerBuildingBlocks();
        TCoreBlocks.registerMisc();
        TCoreBlocks.registerTileBlocks();
        TCoreBlocks.registerTileEntities();
    }

    public static void setup() {
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("charcoal_block"), 5, 5);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("gunpowder_block"), 15, 100);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("sugar_cane_block"), 60, 20);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("bamboo_block"), 60, 20);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("sawdust_block"), 10, 10);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("coal_coke_block"), 5, 5);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("bitumen_block"), 5, 5);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("tar_block"), 5, 5);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get("rosin_block"), 5, 5);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("slime_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("redstone_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("glowstone_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("ender_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("phyto_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("earth_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("fire_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("ice_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("lightning_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ThermalCore.BLOCKS.get("nuke_tnt")), (IDispenseItemBehavior)TNTBlockCoFH.DISPENSER_BEHAVIOR);
    }

    private static void registerVanilla() {
        RegistrationHelper.registerBlockAndItem("charcoal_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).func_235861_h_()), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("charcoal_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(16000).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS)));
        RegistrationHelper.registerBlock("gunpowder_block", () -> new GunpowderBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151670_w).func_200943_b(0.5f).func_200947_a(SoundType.field_185855_h).harvestTool(ToolType.SHOVEL)), ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("sugar_cane_block", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151669_i).func_200943_b(1.0f).func_200947_a(SoundType.field_222472_s).harvestTool(ToolType.HOE)){

            public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.func_225503_b_(fallDistance, 0.6f);
            }
        }, ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("bamboo_block", () -> new RotatedPillarBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151669_i).func_200943_b(1.0f).func_200947_a(SoundType.field_222468_o).harvestTool(ToolType.AXE)){

            public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.func_225503_b_(fallDistance, 0.8f);
            }
        }, ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("apple_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151645_D).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)), ThermalItemGroups.THERMAL_FOODS, ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("carrot_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193562_N).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)), ThermalItemGroups.THERMAL_FOODS, ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("potato_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193573_Y).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)), ThermalItemGroups.THERMAL_FOODS, ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
        RegistrationHelper.registerBlock("beetroot_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193559_aa).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)), ThermalItemGroups.THERMAL_FOODS, ThermalFlags.getFlag(ThermalFlags.FLAG_VANILLA_BLOCKS));
    }

    private static void registerResources() {
        RegistrationHelper.registerBlock("apatite_ore", () -> new OreBlockCoFH(1).xp(0, 2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_APATITE));
        RegistrationHelper.registerBlock("cinnabar_ore", () -> new OreBlockCoFH(1).xp(1, 3), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CINNABAR));
        RegistrationHelper.registerBlock("niter_ore", () -> new OreBlockCoFH(1).xp(0, 2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NITER));
        RegistrationHelper.registerBlock("sulfur_ore", () -> new OreBlockCoFH(1).xp(0, 2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SULFUR));
        RegistrationHelper.registerBlock("copper_ore", () -> new OreBlockCoFH(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_COPPER));
        RegistrationHelper.registerBlock("tin_ore", () -> new OreBlockCoFH(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN));
        RegistrationHelper.registerBlock("lead_ore", () -> new OreBlockCoFH(2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD));
        RegistrationHelper.registerBlock("silver_ore", () -> new OreBlockCoFH(2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER));
        RegistrationHelper.registerBlock("nickel_ore", () -> new OreBlockCoFH(2), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL));
        RegistrationHelper.registerBlock("ruby_ore", () -> new OreBlockCoFH(2).xp(3, 7), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_RUBY));
        RegistrationHelper.registerBlock("sapphire_ore", () -> new OreBlockCoFH(2).xp(3, 7), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SAPPHIRE));
        RegistrationHelper.registerBlockAndItem("oil_sand", () -> new SandBlock(14406560, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150354_m).harvestTool(ToolType.SHOVEL)), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("oil_sand"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(2400).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_OIL)));
        RegistrationHelper.registerBlockAndItem("oil_red_sand", () -> new SandBlock(11098145, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196611_F).harvestTool(ToolType.SHOVEL)), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("oil_red_sand"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(2400).setShowInGroups(ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_OIL)));
    }

    private static void registerStorage() {
        RegistrationHelper.registerBlock("apatite_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193564_P).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("cinnabar_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193559_aa).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("niter_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193561_M).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlockAndItem("sulfur_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193565_Q).func_200948_a(3.0f, 3.0f).func_200947_a(SoundType.field_185851_d).harvestTool(ToolType.PICKAXE).func_235861_h_()){

            public boolean isFireSource(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
                return side == Direction.UP;
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("sulfur_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(12000));
        RegistrationHelper.registerBlock("copper_block", () -> TCoreBlocks.storageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_COPPER));
        RegistrationHelper.registerBlock("tin_block", () -> TCoreBlocks.storageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_TIN));
        RegistrationHelper.registerBlock("lead_block", () -> TCoreBlocks.storageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_LEAD));
        RegistrationHelper.registerBlock("silver_block", () -> TCoreBlocks.storageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SILVER));
        RegistrationHelper.registerBlock("nickel_block", () -> TCoreBlocks.storageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_NICKEL));
        RegistrationHelper.registerBlock("bronze_block", () -> TCoreBlocks.storageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_BRONZE));
        RegistrationHelper.registerBlock("electrum_block", () -> TCoreBlocks.storageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_ELECTRUM));
        RegistrationHelper.registerBlock("invar_block", () -> TCoreBlocks.storageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_INVAR));
        RegistrationHelper.registerBlock("constantan_block", () -> TCoreBlocks.storageBlock(1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_CONSTANTAN));
        RegistrationHelper.registerBlock("signalum_block", () -> new SignalumBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151645_D).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_235861_h_().func_235838_a_(BlockHelper.lightValue((int)7)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("lumium_block", () -> new LumiumBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151673_t).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e).harvestLevel(1).harvestTool(ToolType.PICKAXE).func_235861_h_().func_235838_a_(BlockHelper.lightValue((int)15)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("enderium_block", () -> new EnderiumBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151679_y).func_200948_a(25.0f, 30.0f).func_200947_a(SoundType.field_235596_R_).harvestLevel(2).harvestTool(ToolType.PICKAXE).func_235861_h_().func_235838_a_(BlockHelper.lightValue((int)3)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("ruby_block", () -> TCoreBlocks.storageBlock(MaterialColor.field_151645_D, 1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_RUBY));
        RegistrationHelper.registerBlock("sapphire_block", () -> TCoreBlocks.storageBlock(MaterialColor.field_151649_A, 1), ThermalFlags.getFlag(ThermalFlags.FLAG_RESOURCE_SAPPHIRE));
        RegistrationHelper.registerBlockAndItem("sawdust_block", () -> new FallingBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(1.0f, 1.0f).func_200947_a(SoundType.field_185855_h).harvestTool(ToolType.SHOVEL)){

            @OnlyIn(value=Dist.CLIENT)
            public int func_189876_x(BlockState state, IBlockReader reader, BlockPos pos) {
                return 11507581;
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("sawdust_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(2400));
        RegistrationHelper.registerBlockAndItem("coal_coke_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(5.0f, 6.0f).func_235861_h_()), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("coal_coke_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(32000));
        RegistrationHelper.registerBlockAndItem("bitumen_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(5.0f, 10.0f).func_200947_a(SoundType.field_235589_K_).func_235861_h_()), () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("bitumen_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(16000));
        RegistrationHelper.registerBlockAndItem("tar_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(2.0f, 4.0f).func_226897_b_(0.8f).func_226898_c_(0.8f).func_200947_a(SoundType.field_235589_K_).harvestTool(ToolType.SHOVEL)){

            public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.func_225503_b_(fallDistance, 0.8f);
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("tar_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(8000));
        RegistrationHelper.registerBlockAndItem("rosin_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_151676_q).func_200948_a(2.0f, 4.0f).func_226897_b_(0.8f).func_226898_c_(0.8f).func_200947_a(SoundType.field_226947_m_).harvestTool(ToolType.SHOVEL)){

            public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
                entityIn.func_225503_b_(fallDistance, 0.8f);
            }
        }, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get("rosin_block"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_BLOCKS)).setBurnTime(8000));
        RegistrationHelper.registerBlock("rubber_block", () -> new RubberBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_193561_M).func_200948_a(3.0f, 3.0f).func_226898_c_(1.25f).func_200947_a(SoundType.field_235580_B_)));
        RegistrationHelper.registerBlock("cured_rubber_block", () -> new RubberBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(3.0f, 3.0f).func_226898_c_(1.25f).func_200947_a(SoundType.field_235580_B_)));
        RegistrationHelper.registerBlock("slag_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("rich_slag_block", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
    }

    private static void registerBuildingBlocks() {
        RegistrationHelper.registerBlock("machine_frame", () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).func_226896_b_()), ThermalFlags.getFlag("machine_frame"));
        RegistrationHelper.registerBlock("energy_cell_frame", () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).func_226896_b_()), ThermalFlags.getFlag("energy_cell_frame"));
        RegistrationHelper.registerBlock("fluid_cell_frame", () -> new Block(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).func_226896_b_()), ThermalFlags.getFlag("fluid_cell_frame"));
        RegistrationHelper.registerBlock("obsidian_glass", () -> new HardenedGlassBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151654_J).func_200948_a(5.0f, 1000.0f).func_200947_a(SoundType.field_185853_f).func_226896_b_()));
        RegistrationHelper.registerBlock("signalum_glass", () -> new SignalumGlassBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151645_D).func_200948_a(5.0f, 1000.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(BlockHelper.lightValue((int)7)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("lumium_glass", () -> new LumiumGlassBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151673_t).func_200948_a(5.0f, 1000.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(BlockHelper.lightValue((int)15)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("enderium_glass", () -> new EnderiumGlassBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151592_s, (MaterialColor)MaterialColor.field_151679_y).func_200948_a(5.0f, 1000.0f).func_200947_a(SoundType.field_185853_f).func_235838_a_(BlockHelper.lightValue((int)3)).func_226896_b_()), Rarity.UNCOMMON);
        RegistrationHelper.registerBlock("white_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151666_j).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("orange_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151676_q).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("magenta_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151675_r).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("light_blue_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151674_s).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("yellow_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151673_t).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("lime_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151672_u).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("pink_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151671_v).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("gray_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151670_w).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("light_gray_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_197656_x).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("cyan_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151679_y).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("purple_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151678_z).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("blue_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151649_A).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("brown_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151650_B).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("green_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151651_C).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("red_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151645_D).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("black_rockwool", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(2.0f, 6.0f).func_200947_a(SoundType.field_185854_g)), ThermalFlags.getFlag(ThermalFlags.FLAG_ROCKWOOL));
        RegistrationHelper.registerBlock("polished_slag", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("chiseled_slag", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("slag_bricks", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("cracked_slag_bricks", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("polished_rich_slag", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("chiseled_rich_slag", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("rich_slag_bricks", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
        RegistrationHelper.registerBlock("cracked_rich_slag_bricks", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_193560_ab).func_200948_a(1.5f, 6.0f).func_200947_a(SoundType.field_235587_I_).harvestTool(ToolType.PICKAXE).func_235861_h_()));
    }

    private static void registerMisc() {
        RegistrationHelper.registerBlock("slime_tnt", () -> new TNTBlockCoFH(SlimeTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_193574_Z).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, ThermalFlags.getFlag(ThermalFlags.FLAG_BASIC_EXPLOSIVES));
        RegistrationHelper.registerBlock("redstone_tnt", () -> new TNTBlockCoFH(RedstoneTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151645_D).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, ThermalFlags.getFlag(ThermalFlags.FLAG_BASIC_EXPLOSIVES));
        RegistrationHelper.registerBlock("glowstone_tnt", () -> new TNTBlockCoFH(GlowstoneTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151673_t).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, ThermalFlags.getFlag(ThermalFlags.FLAG_BASIC_EXPLOSIVES));
        RegistrationHelper.registerBlock("ender_tnt", () -> new TNTBlockCoFH(EnderTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, ThermalFlags.getFlag(ThermalFlags.FLAG_BASIC_EXPLOSIVES));
        RegistrationHelper.registerBlock("phyto_tnt", () -> new TNTBlockCoFH(PhytoTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, ThermalFlags.getFlag(ThermalFlags.FLAG_PHYTOGRO_EXPLOSIVES));
        RegistrationHelper.registerBlock("earth_tnt", () -> new TNTBlockCoFH(EarthTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151654_J).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        RegistrationHelper.registerBlock("fire_tnt", () -> new TNTBlockCoFH(FireTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151645_D).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        RegistrationHelper.registerBlock("ice_tnt", () -> new TNTBlockCoFH(IceTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151657_g).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        RegistrationHelper.registerBlock("lightning_tnt", () -> new TNTBlockCoFH(LightningTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_151673_t).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, ThermalFlags.getFlag(ThermalFlags.FLAG_ELEMENTAL_EXPLOSIVES));
        RegistrationHelper.registerBlock("nuke_tnt", () -> new TNTBlockCoFH(NukeTNTEntity::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151590_u, (MaterialColor)MaterialColor.field_193566_R).func_200943_b(0.0f).func_200947_a(SoundType.field_185850_c)), ThermalItemGroups.THERMAL_TOOLS, Rarity.UNCOMMON, ThermalFlags.getFlag(ThermalFlags.FLAG_NUCLEAR_EXPLOSIVES));
    }

    private static void registerTileBlocks() {
        IntSupplier deviceAugs = () -> ThermalConfig.deviceAugments;
        RegistrationHelper.registerAugmentableBlock("device_hive_extractor", () -> new TileBlockActive4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_222470_q).func_200943_b(2.5f).harvestTool(ToolType.AXE), DeviceHiveExtractorTile::new), deviceAugs, DeviceHiveExtractorTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_hive_extractor"));
        RegistrationHelper.registerAugmentableBlock("device_tree_extractor", () -> new TileBlockActive4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_222470_q).func_200943_b(2.5f).harvestTool(ToolType.AXE), DeviceTreeExtractorTile::new), deviceAugs, DeviceTreeExtractorTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_tree_extractor"));
        RegistrationHelper.registerAugmentableBlock("device_fisher", () -> new TileBlockActive4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_222470_q).func_200943_b(2.5f).harvestTool(ToolType.AXE), DeviceFisherTile::new), deviceAugs, DeviceFisherTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_fisher"));
        RegistrationHelper.registerAugmentableBlock("device_soil_infuser", () -> new TileBlockActive4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_222470_q).func_200943_b(2.5f).harvestTool(ToolType.AXE).func_235838_a_(BlockHelper.lightValue((BooleanProperty)Constants.ACTIVE, (int)10)), DeviceSoilInfuserTile::new), deviceAugs, DeviceSoilInfuserTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_soil_infuser"));
        RegistrationHelper.registerAugmentableBlock("device_water_gen", () -> new TileBlockActive4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE), DeviceWaterGenTile::new), deviceAugs, DeviceWaterGenTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_water_gen"));
        RegistrationHelper.registerAugmentableBlock("device_rock_gen", () -> new TileBlockActive4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).func_235838_a_(BlockHelper.lightValue((BooleanProperty)Constants.ACTIVE, (int)14)), DeviceRockGenTile::new), deviceAugs, DeviceRockGenTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_rock_gen"));
        RegistrationHelper.registerAugmentableBlock("device_collector", () -> new TileBlockActive4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE), DeviceCollectorTile::new), deviceAugs, DeviceCollectorTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_collector"));
        RegistrationHelper.registerAugmentableBlock("device_nullifier", () -> new TileBlockActive4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).func_235838_a_(BlockHelper.lightValue((BooleanProperty)Constants.ACTIVE, (int)7)), DeviceNullifierTile::new), deviceAugs, DeviceNullifierTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_nullifier"));
        RegistrationHelper.registerAugmentableBlock("device_potion_diffuser", () -> new TileBlockActive4Way(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE), DevicePotionDiffuserTile::new), deviceAugs, DevicePotionDiffuserTile.AUG_VALIDATOR, ThermalFlags.getFlag("device_potion_diffuser"));
        IntSupplier storageAugs = () -> ThermalConfig.storageAugments;
        RegistrationHelper.registerAugmentableBlock("tinker_bench", () -> new TileBlockCoFH(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_222470_q).func_200943_b(2.5f).harvestTool(ToolType.AXE), TinkerBenchTile::new), storageAugs, TinkerBenchTile.AUG_VALIDATOR, ThermalFlags.getFlag("tinker_bench"));
        RegistrationHelper.registerAugmentableBlock("charge_bench", () -> new TileBlockActive(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).func_235838_a_(BlockHelper.lightValue((BooleanProperty)Constants.ACTIVE, (int)7)), ChargeBenchTile::new), storageAugs, ChargeBenchTile.AUG_VALIDATOR, ThermalFlags.getFlag("charge_bench"));
        ThermalCore.BLOCKS.register("energy_cell", () -> new TileBlockCell(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).func_226896_b_(), EnergyCellTile::new));
        ThermalCore.ITEMS.register("energy_cell", () -> new EnergyCellBlockItem((Block)ThermalCore.BLOCKS.get("energy_cell"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_DEVICES)).setNumSlots(storageAugs).setAugValidator(ThermalAugmentRules.ENERGY_STORAGE_VALIDATOR).setShowInGroups(ThermalFlags.getFlag("energy_cell")));
        ThermalCore.BLOCKS.register("fluid_cell", () -> new TileBlockCell(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_222475_v).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).func_226896_b_(), FluidCellTile::new));
        ThermalCore.ITEMS.register("fluid_cell", () -> new FluidCellBlockItem((Block)ThermalCore.BLOCKS.get("fluid_cell"), new Item.Properties().func_200916_a(ThermalItemGroups.THERMAL_DEVICES)).setNumSlots(storageAugs).setAugValidator(ThermalAugmentRules.FLUID_STORAGE_VALIDATOR).setShowInGroups(ThermalFlags.getFlag("fluid_cell")));
    }

    private static void registerTileEntities() {
        ThermalCore.TILE_ENTITIES.register("device_hive_extractor", () -> TileEntityType.Builder.func_223042_a(DeviceHiveExtractorTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_HIVE_EXTRACTOR_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("device_tree_extractor", () -> TileEntityType.Builder.func_223042_a(DeviceTreeExtractorTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_TREE_EXTRACTOR_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("device_fisher", () -> TileEntityType.Builder.func_223042_a(DeviceFisherTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_FISHER_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("device_soil_infuser", () -> TileEntityType.Builder.func_223042_a(DeviceSoilInfuserTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_SOIL_INFUSER_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("device_water_gen", () -> TileEntityType.Builder.func_223042_a(DeviceWaterGenTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_WATER_GEN_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("device_rock_gen", () -> TileEntityType.Builder.func_223042_a(DeviceRockGenTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_ROCK_GEN_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("device_collector", () -> TileEntityType.Builder.func_223042_a(DeviceCollectorTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_COLLECTOR_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("device_nullifier", () -> TileEntityType.Builder.func_223042_a(DeviceNullifierTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_NULLIFIER_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("device_potion_diffuser", () -> TileEntityType.Builder.func_223042_a(DevicePotionDiffuserTile::new, (Block[])new Block[]{TCoreReferences.DEVICE_POTION_DIFFUSER_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("tinker_bench", () -> TileEntityType.Builder.func_223042_a(TinkerBenchTile::new, (Block[])new Block[]{TCoreReferences.TINKER_BENCH_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("charge_bench", () -> TileEntityType.Builder.func_223042_a(ChargeBenchTile::new, (Block[])new Block[]{TCoreReferences.CHARGE_BENCH_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("energy_cell", () -> TileEntityType.Builder.func_223042_a(EnergyCellTile::new, (Block[])new Block[]{TCoreReferences.ENERGY_CELL_BLOCK}).func_206865_a(null));
        ThermalCore.TILE_ENTITIES.register("fluid_cell", () -> TileEntityType.Builder.func_223042_a(FluidCellTile::new, (Block[])new Block[]{TCoreReferences.FLUID_CELL_BLOCK}).func_206865_a(null));
    }

    private static Block storageBlock(int harvestLevel) {
        return new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151668_h).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e).harvestLevel(harvestLevel).harvestTool(ToolType.PICKAXE).func_235861_h_());
    }

    private static Block storageBlock(MaterialColor color, int harvestLevel) {
        return new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)color).func_200948_a(5.0f, 6.0f).func_200947_a(SoundType.field_185852_e).harvestLevel(harvestLevel).harvestTool(ToolType.PICKAXE).func_235861_h_());
    }
}

