/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.UpgradeInventoryPartBase;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TextureBlitData;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.utils.UV;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankClickMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.tank.TankUpgradeContainer;

public class TankInventoryPart
extends UpgradeInventoryPartBase<TankUpgradeContainer> {
    private static final TextureBlitData OVERLAY = new TextureBlitData(GuiHelper.GUI_CONTROLS, Dimension.SQUARE_256, new UV(47, 30), new Dimension(16, 18));
    private final Position pos;
    private final int height;
    private final BackpackScreen screen;

    public TankInventoryPart(int upgradeSlot, TankUpgradeContainer container, Position pos, int height, BackpackScreen screen) {
        super(upgradeSlot, container);
        this.pos = pos;
        this.height = height;
        this.screen = screen;
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY) {
        int i;
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.getY(), GuiHelper.BAR_BACKGROUND_TOP);
        int yOffset = 18;
        for (i = 0; i < (this.height - 36) / 18; ++i) {
            GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.getY() + yOffset, GuiHelper.BAR_BACKGROUND_MIDDLE);
            yOffset += 18;
        }
        GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft(), this.pos.getY() + yOffset, GuiHelper.BAR_BACKGROUND_BOTTOM);
        this.renderFluid(matrixStack, mouseX, mouseY);
        yOffset = 0;
        for (i = 0; i < this.height / 18; ++i) {
            GuiHelper.blit(this.screen.getMinecraft(), matrixStack, this.getTankLeft() + 1, this.pos.getY() + yOffset, OVERLAY);
            yOffset += 18;
        }
    }

    private int getTankLeft() {
        return this.pos.getX() + 9;
    }

    @Override
    public boolean handleMouseReleased(double mouseX, double mouseY, int button) {
        if (mouseX < (double)(this.screen.getGuiLeft() + this.getTankLeft()) || mouseX >= (double)(this.screen.getGuiLeft() + this.getTankLeft() + 18) || mouseY < (double)(this.screen.getGuiTop() + this.pos.getY()) || mouseY >= (double)(this.screen.getGuiTop() + this.pos.getY() + this.height)) {
            return false;
        }
        ClientPlayerEntity player = this.screen.getMinecraft().field_71439_g;
        ItemStack cursorStack = player.field_71071_by.func_70445_o();
        if (!cursorStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return false;
        }
        PacketHandler.sendToServer(new TankClickMessage(this.upgradeSlot));
        return true;
    }

    @Override
    public void renderErrorOverlay(MatrixStack matrixStack) {
        this.screen.renderOverlay(matrixStack, DyeColor.RED.getColorValue() | 0xAA000000, this.getTankLeft() + 1, this.pos.getY() + 1, 16, this.height - 2);
    }

    private void renderTooltip(int mouseX, int mouseY, FluidStack contents, int capacity) {
        int screenX = this.screen.getGuiLeft() + this.pos.getX() + 10;
        int screenY = this.screen.getGuiTop() + this.pos.getY() + 1;
        if (mouseX >= screenX && mouseX < screenX + 16 && mouseY >= screenY && mouseY < screenY + this.height - 2) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (!contents.isEmpty()) {
                tooltip.add(contents.getDisplayName());
            }
            tooltip.add(new TranslationTextComponent(TranslationHelper.translUpgradeKey("tank.contents_tooltip"), new Object[]{String.format("%,d", contents.getAmount()), String.format("%,d", capacity)}));
            GuiHelper.setTooltipToRender(tooltip);
        }
    }

    private void renderFluid(MatrixStack matrixStack, int mouseX, int mouseY) {
        FluidStack contents = ((TankUpgradeContainer)this.container).getContents();
        int capacity = ((TankUpgradeContainer)this.container).getTankCapacity();
        if (contents.isEmpty()) {
            this.renderTooltip(mouseX, mouseY, FluidStack.EMPTY, capacity);
            return;
        }
        Fluid fluid = contents.getFluid();
        int fill = contents.getAmount();
        int displayLevel = (int)((float)(this.height - 2) * ((float)fill / (float)capacity));
        ResourceLocation texture = fluid.getAttributes().getStillTexture(contents);
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(texture);
        this.renderTiledFluidTextureAtlas(matrixStack, still, fluid.getAttributes().getColor(), this.pos.getX() + 10, this.pos.getY() + 1 + this.height - 2 - displayLevel, displayLevel);
        this.renderTooltip(mouseX, mouseY, contents, capacity);
    }

    private void renderTiledFluidTextureAtlas(MatrixStack matrixStack, TextureAtlasSprite sprite, int color, int x, int y, int height) {
        this.screen.getMinecraft().func_110434_K().func_110577_a(sprite.func_229241_m_().func_229223_g_());
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        int spriteHeight = sprite.func_94216_b();
        int spriteWidth = sprite.func_94211_a();
        int startY = y;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        do {
            int renderHeight = Math.min(spriteHeight, height);
            height -= renderHeight;
            float v2 = sprite.func_94207_b((double)(16.0f * (float)renderHeight / (float)spriteHeight));
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            float u2 = sprite.func_94214_a((double)(256.0f / (float)spriteWidth));
            builder.func_227888_a_(matrix, (float)x, (float)startY + (float)renderHeight, 100.0f).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(u1, v2).func_181675_d();
            builder.func_227888_a_(matrix, (float)x + 16.0f, (float)startY + (float)renderHeight, 100.0f).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(u2, v2).func_181675_d();
            builder.func_227888_a_(matrix, (float)x + 16.0f, (float)startY, 100.0f).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(u2, v1).func_181675_d();
            builder.func_227888_a_(matrix, (float)x, (float)startY, 100.0f).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(u1, v1).func_181675_d();
            startY += renderHeight;
        } while (height > 0);
        builder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)builder);
    }
}

