/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FilterLogicBase {
    protected final ItemStack upgrade;
    protected final Consumer<ItemStack> saveHandler;
    protected final String parentTagKey;
    private boolean allowListDefault = false;

    public FilterLogicBase(ItemStack upgrade, Consumer<ItemStack> saveHandler, String parentTagKey) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.parentTagKey = parentTagKey;
    }

    public void setAllowByDefault() {
        this.allowListDefault = true;
    }

    protected void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean stackMatchesFilter(ItemStack stack, ItemStack filter) {
        if (filter.func_190926_b()) {
            return false;
        }
        PrimaryMatch primaryMatch = this.getPrimaryMatch();
        if (primaryMatch == PrimaryMatch.MOD ? !stack.func_77973_b().getRegistryName().func_110624_b().equals(filter.func_77973_b().getRegistryName().func_110624_b()) : (primaryMatch == PrimaryMatch.ITEM ? !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)filter) : primaryMatch == PrimaryMatch.TAGS && !InventoryHelper.anyStackTagMatches(stack, filter))) {
            return false;
        }
        if (this.shouldMatchDurability() && stack.func_77952_i() != filter.func_77952_i()) {
            return false;
        }
        return !this.shouldMatchNbt() || this.areItemStackTagsEqualIgnoreDurability(stack, filter);
    }

    private boolean areItemStackTagsEqualIgnoreDurability(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
            if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
                return false;
            }
            return (stackA.func_77978_p() == null || this.areTagsEqualIgnoreDurability(stackA.func_77978_p(), stackB.func_77978_p())) && stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        return false;
    }

    private boolean areTagsEqualIgnoreDurability(CompoundNBT tagA, @Nullable CompoundNBT tagB) {
        if (tagA == tagB) {
            return true;
        }
        if (tagB == null || tagA.func_186856_d() != tagB.func_186856_d()) {
            return false;
        }
        for (String key : tagA.func_150296_c()) {
            if (!tagB.func_74764_b(key)) {
                return false;
            }
            if (key.equals("Damage") || Objects.equals(tagA.func_74781_a(key), tagB.func_74781_a(key))) continue;
            return false;
        }
        return true;
    }

    public void setAllowList(boolean isAllowList) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "isAllowList", isAllowList);
        this.save();
    }

    public boolean isAllowList() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "isAllowList").orElse(this.allowListDefault);
    }

    public boolean shouldMatchDurability() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchDurability").orElse(false);
    }

    public void setMatchDurability(boolean matchDurability) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchDurability", matchDurability);
        this.save();
    }

    public void setMatchNbt(boolean matchNbt) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchNbt", matchNbt);
        this.save();
    }

    public boolean shouldMatchNbt() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchNbt").orElse(false);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        NBTHelper.setEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", primaryMatch);
        this.save();
    }

    public PrimaryMatch getPrimaryMatch() {
        return NBTHelper.getEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", PrimaryMatch::fromName).orElse(PrimaryMatch.ITEM);
    }
}

