/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackRenderInfo;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.TankPosition;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.BackpackModel;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.RenderHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.render.TankGlassModel;

public class BackpackLayerRenderer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final float CHILD_Y_OFFSET = 0.3f;
    private static final float CHILD_Z_OFFSET = 0.1f;
    private static final float CHILD_SCALE = 0.55f;
    private static final ResourceLocation TANK_GLASS_TEXTURE = new ResourceLocation("sophisticatedbackpacks", "textures/entity/tank_glass.png");
    private static final BackpackModel MODEL = new BackpackModel();
    private static final TankGlassModel TANK_GLASS_MODEL = new TankGlassModel();
    private static final Map<EntityType<?>, Vector3d> entityTranslations = new HashMap();

    public BackpackLayerRenderer(IEntityRenderer<T, M> entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof AbstractClientPlayerEntity) {
            AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)entity;
            SophisticatedBackpacks.PROXY.getPlayerInventoryProvider().getBackpackFromRendered((PlayerEntity)player).ifPresent(backpackRenderInfo -> {
                matrixStack.func_227860_a_();
                boolean wearsArmor = !backpackRenderInfo.isArmorSlot() && !((ItemStack)player.field_71071_by.field_70460_b.get(EquipmentSlotType.CHEST.func_188454_b())).func_190926_b();
                ItemStack backpack = backpackRenderInfo.getBackpack();
                BackpackLayerRenderer.renderBackpack((LivingEntity)player, matrixStack, buffer, packedLight, backpack, wearsArmor);
                matrixStack.func_227865_b_();
            });
        } else {
            ItemStack chestStack = entity.func_184582_a(EquipmentSlotType.CHEST);
            if (chestStack.func_77973_b() instanceof BackpackItem) {
                BackpackLayerRenderer.renderBackpack(entity, matrixStack, buffer, packedLight, chestStack, false);
            }
        }
    }

    public static void renderBackpack(LivingEntity livingEntity, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, ItemStack backpack, boolean wearsArmor) {
        if (livingEntity.func_213453_ef()) {
            matrixStack.func_227861_a_(0.0, 0.2, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(28.647888f));
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        float zOffset = wearsArmor ? -0.35f : -0.3f;
        float yOffset = -0.75f;
        if (livingEntity.func_70631_g_()) {
            zOffset += 0.1f;
            yOffset = 0.3f;
        }
        matrixStack.func_227861_a_(0.0, (double)yOffset, (double)zOffset);
        if (livingEntity.func_70631_g_()) {
            matrixStack.func_227862_a_(0.55f, 0.55f, 0.55f);
        }
        if (entityTranslations.containsKey(livingEntity.func_200600_R())) {
            Vector3d translVector = entityTranslations.get(livingEntity.func_200600_R());
            matrixStack.func_227861_a_(translVector.func_82615_a(), translVector.func_82617_b(), translVector.func_82616_c());
        }
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(wrapper -> {
            IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)RenderHelper.BACKPACK_ENTITY_TEXTURE));
            int clothColor = wrapper.getClothColor();
            int borderColor = wrapper.getBorderColor();
            Item backpackItem = backpack.func_77973_b();
            BackpackRenderInfo renderInfo = wrapper.getRenderInfo();
            Set<TankPosition> tankPositions = renderInfo.getTankRenderInfos().keySet();
            boolean showLeftTank = tankPositions.contains((Object)TankPosition.LEFT);
            boolean showRightTank = tankPositions.contains((Object)TankPosition.RIGHT);
            Optional<IRenderedBatteryUpgrade.BatteryRenderInfo> batteryRenderInfo = renderInfo.getBatteryRenderInfo();
            MODEL.render(matrixStack, packedLight, vertexBuilder, clothColor, borderColor, backpackItem, showLeftTank, showRightTank, batteryRenderInfo.isPresent());
            BackpackLayerRenderer.renderFluids(matrixStack, buffer, packedLight, renderInfo, showLeftTank, showRightTank);
            batteryRenderInfo.ifPresent(info -> BackpackLayerRenderer.renderBatteryCharge(matrixStack, buffer, packedLight, info.getChargeRatio()));
        });
    }

    private static void renderBatteryCharge(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float chargeRatio) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 1.5, 0.0);
        RenderHelper.renderBatteryCharge(matrixStack, buffer, packedLight, chargeRatio);
        matrixStack.func_227865_b_();
    }

    private static void renderFluids(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, BackpackRenderInfo renderInfo, boolean showLeftTank, boolean showRightTank) {
        IRenderedTankUpgrade.TankRenderInfo tankRenderInfo;
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.5f, 0.6f, 0.5f);
        IVertexBuilder vertexBuilder = buffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)TANK_GLASS_TEXTURE));
        TANK_GLASS_MODEL.render(matrixStack, vertexBuilder, packedLight, showLeftTank, showRightTank);
        if (showLeftTank) {
            tankRenderInfo = renderInfo.getTankRenderInfos().get((Object)TankPosition.LEFT);
            tankRenderInfo.getFluid().ifPresent(fluid -> RenderHelper.renderFluid(matrixStack, buffer, packedLight, fluid, tankRenderInfo.getFillRatio(), -14.5f, 37.5f, -1, -2.0f));
        }
        if (showRightTank) {
            tankRenderInfo = renderInfo.getTankRenderInfos().get((Object)TankPosition.RIGHT);
            tankRenderInfo.getFluid().ifPresent(fluid -> RenderHelper.renderFluid(matrixStack, buffer, packedLight, fluid, tankRenderInfo.getFillRatio(), 11.0f, 37.5f, -1, -2.0f));
        }
        matrixStack.func_227865_b_();
    }

    static {
        entityTranslations.put(EntityType.field_200803_q, new Vector3d(0.0, -0.8, 0.0));
    }
}

